clear all;
close all;

%% Plot unit cell band structure along gamma-M-K-gamma point

load('bandstructure_data.mat');

% Distance along the high-symmetric path on which we plot the bandstructure
dis = zeros(size(Eval_mech.kx,2), 1);
dis(1) = 0;
for i=2:size(Eval_mech.kx,2)
    dis(i) = dis(i-1) + sqrt((Eval_mech.kx(i) - Eval_mech.kx(i-1))^2 + (Eval_mech.ky(i) - Eval_mech.ky(i-1))^2);
end

% Plotting
figure()
pbaspect([0.593 1 1])

subplot2 = subplot(1,1,1);
set(subplot2,'FontSize',16,'XTick',[0 2*pi/(geom.mech.amech*sqrt(3)) 2*pi/(geom.mech.amech*sqrt(3))+2*pi/(3*geom.mech.amech) 2*pi/(geom.mech.amech*sqrt(3))+6*pi/(3*geom.mech.amech)],...
    'XTickLabel',{'\Gamma','M','K','\Gamma'});

xlim(subplot2,[0 2*pi/(geom.mech.amech*sqrt(3))+6*pi/(3*geom.mech.amech)]);
ylim(subplot2,[262e6 392e6]);

yticks(linspace(270e6, 390e6, 5))
hold on;
box on;

for i=1:size(Eval_mech.bands,1)
    plot(dis, real(Eval_mech.bands(i,:)), 'Color', 'blue', 'LineWidth', 3);    
end